require( "HiddenObject/script/style.lua" );


gCurScreen = 0;
yGap = 30;
xGap = 60;

LeftGraphics = {
	"HiddenObject/UI/Button/leftnormal.png",
	"HiddenObject/UI/Button/leftdown.png",
	"HiddenObject/UI/Button/leftover.png",
};	

LeftCurveStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = LeftGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

RightGraphics = {
	"HiddenObject/UI/Button/rightnormal.png",
	"HiddenObject/UI/Button/rightdown.png",
	"HiddenObject/UI/Button/rightover.png",
};	

RightCurveStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	font = StandardButtonFont,
	graphics = RightGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

HelpDialogBodyFont = {
  standardFont,
  18,
  Color(173,193,161,255)
};

HelpDialogBodyText = {
	parent=DefaultStyle,
	font = HelpDialogBodyFont,
	flags = kVAlignCenter + kHAlignCenter,
	w=kMax,h=kMax-60
};

function SetScreen( screen )

	if screen == 1 then
		EnableWindow("helptext1",true)
		EnableWindow("helptext2",false)
	elseif screen ==2 then
		EnableWindow("helptext1",false)
		EnableWindow("helptext2",true)
	end

	gCurScreen = screen ;
end

HeaderFont = {
  "HiddenObject/UI/Font/OptimusPrincepsSemiBold.mvec",
  30,
  WhiteColor
};

TextStyle=
{
	parent=HelpDialogBodyText,
	w=320,h=kMax-80
};
function GetWindowX()
	
	x = kCenter;
	if IsMainMenu() then x = 310; end
	return x;
end

function GetWindowY()
	
	y = kCenter - 45;
	if IsMainMenu() then y = 115; end
	return y;
end

MakeDialog
{
	-- Name the modal dialog
	name="help",
	Bitmap
	{
		image="HiddenObject/UI/HelpWindow/background",
		x=GetWindowX(),
		y=GetWindowY(),

		Window
		{
			name="helptext1",
			w=kMax,h=kMax,

			SetStyle(DialogTitleText),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "hiddenobjectgame",
				font = StandardHeaderFont,
				h = 40,
			};
		
			SetStyle(TextStyle),
			Text
			{
				label="hiddenobjectgamehelp1",
				flags = kHAlignCenter ,
				x = 50,
				y = 70,
			},

			SetStyle(LeftCurveStyle),
			Button
			{
				label="close",
				name="close",
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() CloseWindow(); end;
			},
			SetStyle(RightCurveStyle),
			Button
			{
				label="next",
				name="next",
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen+1 ); end;
			}
		},
		Window
		{
			name="helptext2",
			w=kMax,h=kMax,

			

			SetStyle(DialogTitleText),
			Text
			{
				x = kHAlignCenter;
				y = 10;
				name = "title",
				label= "hiddenobjectgame",
				font = StandardHeaderFont,
				h = 40,
			};

			
			SetStyle(TextStyle),
			Text
			{
				label="hiddenobjectgamehelp2",
				flags = kHAlignCenter ,
				x = 45,
				y = 50,
			},
			SetStyle(LeftCurveStyle),
			Button
			{
				label="back",
				name="back",
				align=kHAlignLeft+kVAlignBottom,
				x=xGap,y=kMax-yGap,
				command=function() SetScreen( gCurScreen-1 ); end;
			},
			SetStyle(RightCurveStyle),
			Button
			{
				label="close",
				name="close",
				align=kHAlignRight+kVAlignBottom,
				x=kMax-xGap,y=kMax-yGap,
				command=function() CloseWindow(); end;
			}
		}
	}
}

SetScreen(1);
